<?php
/****************************************************************************
 * DRBRatings
 * http://www.dbscripts.net/ratings/
 * 
 * Copyright (c) 2007-2010 Don B 
 ****************************************************************************/

// Modify this string to reflect the URL where DRBRatings is installed.
// A trailing slash must be included.  This URL will be used in the generated 
// HTML for the image tags, and in the URL for the form submission.
$RATINGS_URL = 'ratings/';

// Names of the form input elements in the ratings form.
// You probably won't need to change these unless the names conflict with some 
// other element on your pages.
$RATING_ID_PARAM_NAME = "ratingid";
$RATING_PARAM_NAME = "rating";

// Precision to use when displaying the average rating
$RATINGS_PRECISION = 2;

// These are the file names for the star graphics.  These graphics 
// files must be located immediately beneath the RATINGS_URL defined above.
// Feel free to customize these graphics.
$IMAGE_STAR_EMPTY = 'empty.png';
$IMAGE_STAR_HALF = 'half.png';
$IMAGE_STAR_FILLED = 'filled.png';

// These are the strings that are displayed in the rating control 
// and the result page.
// Modify these to customize what is displayed to the user.
$CURRENT_RATING_STRING = 'Current Rating:';
$RATING_STRING = '(%s out of %s)';
$NUMBER_OF_RATINGS_STRING = 'Rated %s times.';
$RATE_THIS_STRING = 'Rate it:';
$SUBMIT_BUTTON_STRING = 'Submit';
$RATING_LIST_DEFAULT_LABEL = 'Please Select';
$DUPLICATE_RATE_ERROR_MSG = 'You have already rated!';
$NO_RATING_SELECTED_ERROR_MSG = 'You forgot to select a rating!';

// The maximum number of stars per rating
// Change this to customize the maximum number of stars.
$MAX_STARS = 10;

// List of valid rating IDs.  All rating requests are checked against this list 
// to ensure that malicious users do not submit invalid rating IDs through a 
// cross-site request forgery.  Add or modify values in this array to 
// customize the available rating IDs for new ratings forms.
// All values in this array must be strings.  In addition, they must 
// only use alphanumeric characters (A-Z, a-z, and 0-9).
$VALID_RATING_IDS = array("1", "2");	

// Array containing labels for each rating value
// If no labels are desired, simply leave the array blank.
$RATING_LABELS = array(
	1 => "Awful",
	5 => "Average",
	10 => "Excellent"
);
 
?>
