<?php 

/* So to generate these stupid seo links..

0. ---- make everything direct access urls 
1. ---- Give the htacccess for download
2. ---- give them seourls.php 
3. check for file_exists of seourls.php, if true, include the file
4. Create if statements if function exists) that change article links across the site  (rightside, index, category, search, profile)

http://blogandrew.com/article/profile/1/andrew-olson/

http://blogandrew.com/article/141/Dont-Overlooked-Ebooks-As-The-Path-To-Online-Prosperity/

http://blogandrew.com/article/category/5/computers/



GENERATE SEO URLS */
function generate_seo_link($input,$replace = '-',$remove_words = true,$words_array = array())
{
	//make it lowercase, remove punctuation, remove multiple/leading/ending spaces
	$return = trim(ereg_replace(' +',' ',preg_replace('/[^a-zA-Z0-9\s]/','',strtolower($input))));

	//remove words, if not helpful to seo
	//i like my defaults list in remove_words(), so I wont pass that array
	if($remove_words) { $return = remove_words($return,$replace,$words_array); }

	//convert the spaces to whatever the user wants
	//usually a dash or underscore..
	//...then return the value.
	return str_replace(' ',$replace,$return);
}

/* takes an input, scrubs unnecessary words */
function remove_words($input,$replace,$words_array = array(),$unique_words = true)
{
	//separate all words based on spaces
	$input_array = explode(' ',$input);

	//create the return array
	$return = array();

	//loops through words, remove bad words, keep good ones
	foreach($input_array as $word)
	{
		//if it's a word we should add...
		if(!in_array($word,$words_array) && ($unique_words ? !in_array($word,$return) : true))
		{
			$return[] = $word;
		}
	}

	//return good words separated by dashes
	return implode($replace,$return);
}

?>